// popup.js

document.addEventListener('DOMContentLoaded', () => {
  const form = document.getElementById('optionsForm');
  const status = document.getElementById('status');

  // 读取配置并填充表单
  chrome.storage.sync.get({
    telegramStyle: false,
    darkMode: false,
    backgroundImage: '',
    rightAlignSelf: false,
    showUnreadBadge: false,
    hideActionsMenu: false,
    autoCheckReply: false,
    enableCodeCopy: false,
    enableDblClickReply: false
  }, (items) => {
    document.getElementById('telegramStyle').checked = items.telegramStyle;
    document.getElementById('darkMode').checked = items.darkMode;
    const bgInput = document.getElementById('backgroundImage');
    if (items.backgroundImage) {
      bgInput.value = items.backgroundImage;
    }
    document.getElementById('rightAlignSelf').checked = items.rightAlignSelf;
    document.getElementById('showUnreadBadge').checked = items.showUnreadBadge;
    document.getElementById('hideActionsMenu').checked = items.hideActionsMenu;
    document.getElementById('autoCheckReply').checked = items.autoCheckReply;
    document.getElementById('enableCodeCopy').checked = items.enableCodeCopy;
    document.getElementById('enableDblClickReply').checked = items.enableDblClickReply;
  });

  // 保存配置
  form.addEventListener('submit', (e) => {
    e.preventDefault();
    const options = {
      telegramStyle: document.getElementById('telegramStyle').checked,
      darkMode: document.getElementById('darkMode').checked,
      backgroundImage: document.getElementById('backgroundImage').value,
      rightAlignSelf: document.getElementById('rightAlignSelf').checked,
      showUnreadBadge: document.getElementById('showUnreadBadge').checked,
      hideActionsMenu: document.getElementById('hideActionsMenu').checked,
      autoCheckReply: document.getElementById('autoCheckReply').checked,
      enableCodeCopy: document.getElementById('enableCodeCopy').checked,
      enableDblClickReply: document.getElementById('enableDblClickReply').checked
    };
    chrome.storage.sync.set(options, () => {
      status.textContent = '已保存！';
      setTimeout(() => status.textContent = '', 1500);
      // 通知 content.js 立即刷新设置
      chrome.tabs.query({active: true, currentWindow: true}, (tabs) => {
        if (tabs[0] && tabs[0].url && tabs[0].url.includes('.slack.com')) {
          chrome.tabs.sendMessage(tabs[0].id, {type: 'REFRESH_SLACK_OPTIMIZER'});
        }
      });
    });
  });
});
